<?php

/*

Button Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-button href="#" target="_self" type="default" size="medium"]Button[/fy-button]
[forqy-button href="#" target="_self" type="default" size="medium"]Button[/forqy-button]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_button' ) ) {

	function forqy_shortcode_button( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'href'   => '#',
			'target' => '_self', // _self, _blank
			'type'   => 'default', // default, accent, bordered
			'size'   => 'medium', // micro, small, medium, large, huge
		), $attrs );

		$button = '<a href="' . $attrs['href'] . '" target="' . $attrs['target'] . '" class="fy-button fy-button-' . $attrs['size'] . ' fy-button-' . $attrs['type'] . '">';
		$button .= wp_kses_post( $content );
		$button .= '</a>';

		return $button;

	}

	add_shortcode( 'fy-button', 'forqy_shortcode_button' );
	add_shortcode( 'forqy-button', 'forqy_shortcode_button' );

}
