<?php

/*

Alert Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-alert type="default"][/fy-alert]
[forqy-alert type="default"][/forqy-alert]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_alert' ) ) {

	function forqy_shortcode_alert( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'type' => 'default', // default, accent, success, error
		), $attrs );

		$alert_class = 'fy-alert';
		$alert_class .= $attrs['type'] ? ' fy-alert-' . $attrs['type'] : '';

		$alert = '<div class="fy-shortcode-alert ' . $alert_class . '">';
		$alert .= wp_kses_post( do_shortcode( $content ) );
		$alert .= '</div>';

		return $alert;

	}

	add_shortcode( 'fy-alert', 'forqy_shortcode_alert' );
	add_shortcode( 'forqy-alert', 'forqy_shortcode_alert' );

}
