<?php

/*

Accordion Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-accordion][/fy-accordion]
[forqy-accordion][/forqy-accordion]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_accordion' ) ) {

	function forqy_shortcode_accordion( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'animation' => 'slide', // none, slide, fade
		), $attrs );

		$container_class = 'fy-accordion';
		$container_class .= $attrs['animation'] ? ' fy-accordion-' . $attrs['animation'] : '';

		$container = '<div class="' . $container_class . '">';
		$container .= do_shortcode( shortcode_unautop( $content ) );
		$container .= '</div>';

		return $container;

	}

	add_shortcode( 'fy-accordion', 'forqy_shortcode_accordion' );
	add_shortcode( 'forqy-accordion', 'forqy_shortcode_accordion' );

}

/*
----------------------------------------------------------------------------------------------------
[fy-accordion-section title=""][/fy-section]
[forqy-accordion-section title=""][/forqy-section]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_section' ) ) {

	function forqy_shortcode_section( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'title' => '',
		), $attrs );

		$section_class = 'fy-accordion-section';
		$section_class .= $attrs['title'] ? ' fy-accordion-section-' . sanitize_title( $attrs['title'] ) : null;

		$section = '<section class="' . $section_class . '">';
		$section .= '<input type="checkbox" id="' . sanitize_title( $attrs['title'] ) . '" name="accordion">';
		$section .= '<header class="fy-accordion-section-header">';
		$section .= '<label for="' . sanitize_title( $attrs['title'] ) . '">' . $attrs['title'] . '</label>';
		$section .= '<h3>';
		$section .= $attrs['title'] ? $attrs['title'] : esc_html__( 'No Title', 'forqy' );
		$section .= '</h3>';
		$section .= '</header>';
		$section .= '<div class="fy-accordion-section-content">';
		$section .= '<div class="fy-content">' . do_shortcode( $content ) . '</div>';
		$section .= '</div>';
		$section .= '</section>';

		return $section;

	}

	add_shortcode( 'fy-accordion-section', 'forqy_shortcode_section' );
	add_shortcode( 'forqy-accordion-section', 'forqy_shortcode_section' );

}
