/**
 * TinyMCE Shortcode Buttons
 */

(function () {
    tinymce.PluginManager.add('fy_shortcodes', function (editor) {
        editor.addButton('fy_shortcodes', {
            text: 'Shortcodes',
            icon: 'fy-icon-forqy',
            title: 'Add Shortcode',
            type: 'menubutton',
            menu: [

                // Typography

                {
                    text: 'Typography',
                    icon: 'fy-icon-typography',
                    menu: [
                        // Highlight

                        {
                            text: 'Highlight',
                            icon: 'fy-icon-highlight',
                            onclick: function () {
                                editor.windowManager.open({
                                    title: 'Highlight Shortcode',
                                    body: [{
                                        type: 'listbox',
                                        name: 'color',
                                        label: 'Color',
                                        values: [{
                                            text: 'Default',
                                            value: 'default'
                                        }, {
                                            text: 'Accent',
                                            value: 'accent'
                                        }]
                                    }],
                                    onsubmit: function (e) {
                                        editor.insertContent('[forqy-highlight color="' + e.data.color + '"]' + editor.selection.getContent() + '[/forqy-highlight]');
                                    }
                                });
                            }
                        },

                        // Emphasize

                        {
                            text: 'Emphasize',
                            icon: 'fy-icon-emphasize',
                            onclick: function () {
                                editor.windowManager.open({
                                    title: 'Emphasize Shortcode',
                                    body: [{
                                        type: 'listbox',
                                        name: 'color',
                                        label: 'Color',
                                        values: [{
                                            text: 'Default',
                                            value: 'default'
                                        }, {
                                            text: 'Accent',
                                            value: 'accent'
                                        }]
                                    }],
                                    onsubmit: function (e) {
                                        editor.insertContent('[forqy-emphasize color="' + e.data.color + '"]' + editor.selection.getContent() + '[/forqy-emphasize]');
                                    }
                                });
                            }
                        },

                        // Dropcap

                        {
                            text: 'Dropcap',
                            icon: 'fy-icon-dropcap',
                            onclick: function () {
                                editor.windowManager.open({
                                    title: 'Dropcap Shortcode',
                                    body: [{
                                        type: 'listbox',
                                        name: 'type',
                                        label: 'Type',
                                        values: [{
                                            text: 'Square',
                                            value: 'square'
                                        }, {
                                            text: 'Rounded',
                                            value: 'rounded'
                                        }]
                                    }, {
                                        type: 'listbox',
                                        name: 'color',
                                        label: 'Color',
                                        values: [{
                                            text: 'Default',
                                            value: 'default'
                                        }, {
                                            text: 'Accent',
                                            value: 'accent'
                                        }]
                                    }],
                                    onsubmit: function (e) {
                                        editor.insertContent('[forqy-dropcap type="' + e.data.type + '" color="' + e.data.color + '"]' + editor.selection.getContent() + '[/forqy-dropcap]');
                                    }
                                });
                            }
                        },

                        // Lead-in

                        {
                            text: 'Lead-in',
                            icon: 'fy-icon-leadin',
                            onclick: function () {
                                editor.windowManager.open({
                                    title: 'Lead-in Shortcode',
                                    body: [{
                                        type: 'listbox',
                                        name: 'position',
                                        label: 'Position',
                                        values: [{
                                            text: 'Left',
                                            value: 'left'
                                        }, {
                                            text: 'Right',
                                            value: 'right'
                                        }, {
                                            text: 'Full-width',
                                            value: 'full'
                                        }]
                                    }, {
                                        type: 'listbox',
                                        name: 'color',
                                        label: 'Color',
                                        values: [{
                                            text: 'Default',
                                            value: 'default'
                                        }, {
                                            text: 'Accent',
                                            value: 'accent'
                                        }]
                                    }],
                                    onsubmit: function (e) {
                                        editor.insertContent('[forqy-leadin position="' + e.data.position + '" color="' + e.data.color + '"]' + editor.selection.getContent() + '[/forqy-leadin]');
                                    }
                                });
                            }
                        }]
                },

                // Anchor

                {
                    text: 'Anchor',
                    icon: 'fy-icon-anchor',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Anchor Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'id',
                                label: 'ID',
                                value: ''
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-anchor id="' + e.data.id + '"]');
                            }
                        });
                    }
                },

                // Alert

                {
                    text: 'Alert',
                    icon: 'fy-icon-alert',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Alert Shortcode',
                            body: [{
                                type: 'listbox',
                                name: 'type',
                                label: 'Type',
                                values: [{
                                    text: 'Default',
                                    value: 'default'
                                }, {
                                    text: 'Accent',
                                    value: 'accent'
                                }, {
                                    text: 'Success',
                                    value: 'success'
                                }, {
                                    text: 'Error',
                                    value: 'error'
                                }]
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-alert type="' + e.data.type + '"]' + editor.selection.getContent() + '[/forqy-alert]');
                            }
                        });
                    }
                },

                // Button

                {
                    text: 'Button',
                    icon: 'fy-icon-button',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Button Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'href',
                                label: 'URL',
                                value: ''
                            }, {
                                type: 'listbox',
                                name: 'target',
                                label: 'Target',
                                values: [{
                                    text: 'Current Tab/Window',
                                    value: '_self'
                                }, {
                                    text: 'New Tab/Window',
                                    value: '_blank'
                                }]
                            }, {
                                type: 'listbox',
                                name: 'size',
                                label: 'Size',
                                values: [{
                                    text: 'Medium',
                                    value: 'medium'
                                }, {
                                    text: 'Micro',
                                    value: 'micro'
                                }, {
                                    text: 'Small',
                                    value: 'small'
                                }, {
                                    text: 'Large',
                                    value: 'large'
                                }, {
                                    text: 'Huge',
                                    value: 'huge'
                                }]
                            }, {
                                type: 'listbox',
                                name: 'type',
                                label: 'Type',
                                values: [{
                                    text: 'Default',
                                    value: 'default'
                                }, {
                                    text: 'Accent',
                                    value: 'accent'
                                }, {
                                    text: 'Bordered',
                                    value: 'bordered'
                                }]
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-button href="' + e.data.href + '" target="' + e.data.target + '" size="' + e.data.size + '" type="' + e.data.type + '"]' + editor.selection.getContent() + '[/forqy-button]');
                            }
                        });
                    }
                },

                // Image

                {
                    text: 'Image',
                    icon: 'fy-icon-image',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Lightbox Image Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'src',
                                label: 'Image URL',
                                value: ''
                            }, {
                                type: 'listbox',
                                name: 'size',
                                label: 'Image Size',
                                values: [{
                                    text: 'Thumbnail [150x150]',
                                    value: 'thumbnail'
                                }, {
                                    text: 'Medium [300x300]',
                                    value: 'medium'
                                }, {
                                    text: 'Large [640x640]',
                                    value: 'large'
                                }, {
                                    text: 'Full',
                                    value: 'full'
                                }]
                            }, {
                                type: 'listbox',
                                name: 'align',
                                label: 'Image Alignment',
                                values: [{
                                    text: 'None',
                                    value: 'none'
                                }, {
                                    text: 'Left',
                                    value: 'left'
                                }, {
                                    text: 'Right',
                                    value: 'right'
                                }, {
                                    text: 'Center',
                                    value: 'center'
                                }]
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-image src="' + e.data.src + '" size="' + e.data.size + '" align="' + e.data.align + '"]' + editor.selection.getContent() + '[/forqy-image]');
                            }
                        });
                    }
                },

                // Divider

                {
                    text: 'Divider',
                    icon: 'fy-icon-divider',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Divider Shortcode',
                            body: [{
                                type: 'listbox',
                                name: 'type',
                                label: 'Type',
                                values: [{
                                    text: 'Solid',
                                    value: 'solid'
                                }, {
                                    text: 'Dotted',
                                    value: 'dotted'
                                }, {
                                    text: 'Dashed',
                                    value: 'dashed'
                                }, {
                                    text: 'Double',
                                    value: 'double'
                                }]
                            }, {
                                type: 'listbox',
                                name: 'color',
                                label: 'Color',
                                values: [{
                                    text: 'Default',
                                    value: 'default'
                                }, {
                                    text: 'Accent',
                                    value: 'accent'
                                }]
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-divider type="' + e.data.type + '" color="' + e.data.color + '"]');
                            }
                        });
                    }
                },

                // Spacer

                {
                    text: 'Spacer',
                    icon: 'fy-icon-spacer',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Spacer Shortcode',
                            body: [{
                                type: 'listbox',
                                name: 'size',
                                label: 'Size',
                                values: [{
                                    text: '5px',
                                    value: '5'
                                }, {
                                    text: '10px',
                                    value: '10'
                                }, {
                                    text: '20px',
                                    value: '20'
                                }, {
                                    text: '30px',
                                    value: '30'
                                }, {
                                    text: '40px',
                                    value: '40'
                                }, {
                                    text: '50px',
                                    value: '50'
                                }, {
                                    text: '60px',
                                    value: '60'
                                }, {
                                    text: '70px',
                                    value: '70'
                                }, {
                                    text: '80px',
                                    value: '80'
                                }]
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-spacer size="' + e.data.size + '"]');
                            }
                        });
                    }
                },

                // Centerer

                {
                    text: 'Centerer',
                    icon: 'fy-icon-centerer',
                    onclick: function () {
                        editor.windowManager.open({
                            title: 'Centerer Shortcode',
                            body: [{
                                type: 'listbox',
                                name: 'size',
                                label: 'Size',
                                values: [{
                                    text: '100%',
                                    value: '100'
                                }, {
                                    text: '75%',
                                    value: '75'
                                }, {
                                    text: '50%',
                                    value: '50'
                                }]
                            }],
                            onsubmit: function (e) {
                                editor.insertContent('[forqy-centerer size="' + e.data.size + '"]<br>' + editor.selection.getContent() + '<br>[/forqy-centerer]<br>');
                            }
                        });
                    }
                },

                // Layouts

                {
                    text: 'Layouts',
                    icon: 'fy-icon-layouts',
                    menu: [
                        {
                            text: '2 columns',
                            icon: 'fy-icon-layout-2',
                            onclick: function () {
                                editor.insertContent(
                                    '[forqy-container align="top" gutter="medium"]<br>' +
                                    '[forqy-column width="50" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 1<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="50" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 2<br>' +
                                    '[/forqy-column]<br>' +
                                    '[/forqy-container]'
                                );
                            }
                        },
                        {
                            text: '3 columns',
                            icon: 'fy-icon-layout-3',
                            onclick: function () {
                                editor.insertContent(
                                    '[forqy-container align="top" gutter="medium"]<br>' +
                                    '[forqy-column width="33" width-tablet="100" width-phone="100"]<br>' +
                                    'Content of Column 1<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="33" width-tablet="100" width-phone="100"]<br>' +
                                    'Content of Column 2<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="33" width-tablet="100" width-phone="100"]<br>' +
                                    'Content of Column 3<br>' +
                                    '[/forqy-column]<br>' +
                                    '[/forqy-container]'
                                );
                            }
                        },
                        {
                            text: '4 columns',
                            icon: 'fy-icon-layout-4',
                            onclick: function () {
                                editor.insertContent(
                                    '[forqy-container align="top" gutter="medium"]<br>' +
                                    '[forqy-column width="25" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 1<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="25" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 2<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="25" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 3<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="25" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 4<br>' +
                                    '[/forqy-column]<br>' +
                                    '[/forqy-container]'
                                );
                            }
                        },
                        {
                            text: '5 columns',
                            icon: 'fy-icon-layout-5',
                            onclick: function () {
                                editor.insertContent(
                                    '[forqy-container align="top" gutter="medium"]<br>' +
                                    '[forqy-column width="20" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 1<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="20" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 2<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="20" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 3<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="20" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 4<br>' +
                                    '[/forqy-column]<br>' +
                                    '[forqy-column width="20" width-tablet="50" width-phone="100"]<br>' +
                                    'Content of Column 5<br>' +
                                    '[/forqy-column]<br>' +
                                    '[/forqy-container]'
                                );
                            }
                        }
                    ]
                },

                // Grid

                {
                    text: 'Grid',
                    icon: 'fy-icon-grid',
                    menu: [
                        {
                            text: 'Grid container',
                            onclick: function () {
                                editor.windowManager.open({
                                    title: 'Container Shortcode',
                                    body: [{
                                        type: 'listbox',
                                        name: 'align',
                                        label: 'Align',
                                        values: [{
                                            text: 'Top',
                                            value: 'top'
                                        }, {
                                            text: 'Center',
                                            value: 'center'
                                        }, {
                                            text: 'Bottom',
                                            value: 'bottom'
                                        }, {
                                            text: 'Stretch',
                                            value: 'stretch'
                                        }, {
                                            text: 'Baseline',
                                            value: 'baseline'
                                        }, {
                                            text: 'Initial',
                                            value: 'initial'
                                        }
                                        ]
                                    }, {
                                        type: 'listbox',
                                        name: 'gutter',
                                        label: 'Gutter',
                                        values: [{
                                            text: 'Medium',
                                            value: 'medium'
                                        }, {
                                            text: '0',
                                            value: '0'
                                        }, {
                                            text: '1px',
                                            value: '1'
                                        }, {
                                            text: 'xSmall',
                                            value: 'xsmall'
                                        }, {
                                            text: 'Small',
                                            value: 'small'
                                        }, {
                                            text: 'Large',
                                            value: 'large'
                                        }, {
                                            text: 'xLarge',
                                            value: 'xlarge'
                                        }]
                                    }],
                                    onsubmit: function (e) {
                                        editor.insertContent('[forqy-container align="' + e.data.align + '" gutter="' + e.data.gutter + '"]<br>' + editor.selection.getContent() + '<br>[/forqy-container]<br>');
                                    }
                                });
                            }
                        },
                        {
                            text: 'Grid column',
                            onclick: function () {
                                editor.windowManager.open({
                                    title: 'Container Shortcode',
                                    body: [{
                                        type: 'listbox',
                                        name: 'width',
                                        label: 'Width',
                                        values: [{
                                            text: 'Auto',
                                            value: 'auto'
                                        }, {
                                            text: '100%',
                                            value: '100'
                                        }, {
                                            text: '90%',
                                            value: '90'
                                        }, {
                                            text: '80%',
                                            value: '80'
                                        }, {
                                            text: '75%',
                                            value: '75'
                                        }, {
                                            text: '70%',
                                            value: '70'
                                        }, {
                                            text: '66%',
                                            value: '66'
                                        }, {
                                            text: '60%',
                                            value: '60'
                                        }, {
                                            text: '50%',
                                            value: '50'
                                        }, {
                                            text: '40%',
                                            value: '40'
                                        }, {
                                            text: '33%',
                                            value: '33'
                                        }, {
                                            text: '30%',
                                            value: '30'
                                        }, {
                                            text: '20%',
                                            value: '20'
                                        }, {
                                            text: '10%',
                                            value: '10'
                                        }]
                                    }, {
                                        type: 'listbox',
                                        name: 'width_tablet',
                                        label: 'Tablet width',
                                        values: [{
                                            text: '100%',
                                            value: '100'
                                        }, {
                                            text: '90%',
                                            value: '90'
                                        }, {
                                            text: '80%',
                                            value: '80'
                                        }, {
                                            text: '75%',
                                            value: '75'
                                        }, {
                                            text: '70%',
                                            value: '70'
                                        }, {
                                            text: '66%',
                                            value: '66'
                                        }, {
                                            text: '60%',
                                            value: '60'
                                        }, {
                                            text: '50%',
                                            value: '50'
                                        }, {
                                            text: '40%',
                                            value: '40'
                                        }, {
                                            text: '33%',
                                            value: '33'
                                        }, {
                                            text: '30%',
                                            value: '30'
                                        }, {
                                            text: '20%',
                                            value: '20'
                                        }, {
                                            text: '10%',
                                            value: '10'
                                        }]
                                    }, {
                                        type: 'listbox',
                                        name: 'width_phone',
                                        label: 'Phone width',
                                        values: [{
                                            text: '100%',
                                            value: '100'
                                        }, {
                                            text: '90%',
                                            value: '90'
                                        }, {
                                            text: '80%',
                                            value: '80'
                                        }, {
                                            text: '75%',
                                            value: '75'
                                        }, {
                                            text: '70%',
                                            value: '70'
                                        }, {
                                            text: '66%',
                                            value: '66'
                                        }, {
                                            text: '60%',
                                            value: '60'
                                        }, {
                                            text: '50%',
                                            value: '50'
                                        }, {
                                            text: '40%',
                                            value: '40'
                                        }, {
                                            text: '33%',
                                            value: '33'
                                        }, {
                                            text: '30%',
                                            value: '30'
                                        }, {
                                            text: '20%',
                                            value: '20'
                                        }, {
                                            text: '10%',
                                            value: '10'
                                        }]
                                    }],
                                    onsubmit: function (e) {
                                        editor.insertContent('[forqy-column width="' + e.data.width + '" width-tablet="' + e.data.width_tablet + '" width-phone="' + e.data.width_phone + '"]<br>' + editor.selection.getContent() + '<br>[/forqy-column]');
                                    }
                                });
                            }
                        }
                    ]
                },

                // Forms

                {
                    text: 'Forms',
                    icon: 'fy-icon-forms',
                    menu: [
                        {
                            text: 'Contact Form',
                            onclick: function () {
                                editor.insertContent('[forqy-form-contact width="auto"]');
                            }
                        },
                        {
                            text: 'Reservation Form',
                            onclick: function () {
                                editor.insertContent('[forqy-form-reservation width="auto"]');
                            }
                        }
                    ]
                }

                // END

            ]
        });
    });
})();