<?php

/**
 * FORQY Less
 *
 * @version 1.0.3
 * @author  FORQY
 * @url     https://forqy.website/
 * @license GPL-3.0-or-later
 */

// Prevent Direct File Access
defined( 'ABSPATH' ) or exit;

/**
 * Less Compiler
 */
require dirname( __FILE__ ) . '/inc/less.php';


if ( ! function_exists( 'forqy_less_path' ) ) {

	/**
	 * Less Path
	 *
	 * @param $path
	 *
	 * @return string
	 */
	function forqy_less_path( $path ): string {
		return sprintf( '%s-%s', $path, basename( get_stylesheet_directory() ) );
	}

	apply_filters( 'style_loader_src', 'forqy_less_path', 100000, 1 );

}
