<?php

/*

Reservation Form

*/

if ( ! function_exists( 'forqy_form_reservation' ) ) {

	function forqy_form_reservation() {

		// Error Messages
		$error_reservation_date          = esc_html__( 'Please fill in the date.', 'forqy' );
		$error_reservation_time          = esc_html__( 'Please fill in the time.', 'forqy' );
		$error_reservation_persons       = esc_html__( 'Please fill in the number of guests.', 'forqy' );
		$error_reservation_name          = esc_html__( 'Please fill in your name.', 'forqy' );
		$error_reservation_email         = esc_html__( 'Please fill in your email address.', 'forqy' );
		$error_reservation_email_invalid = esc_html__( 'Please fill in the valid email address.', 'forqy' );
		$error_reservation_phone         = esc_html__( 'Please fill in your phone number.', 'forqy' );
		$error_reservation_terms         = esc_html__( 'Please accept our terms and conditions.', 'forqy' );
		$error_reservation_captcha       = esc_html__( 'Please verify the captcha.', 'forqy' );

		// From
		$from_name  = get_theme_mod( 'fy_form_from_name', get_bloginfo( 'name' ) );
		$from_email = get_theme_mod( 'fy_form_from_email', get_option( 'admin_email' ) );
		// Recipient
		$recipient_admin = get_theme_mod( 'fy_form_reservation_email', get_option( 'admin_email' ) );
		$recipient       = array( $recipient_admin );
		// Subject
		$subject = get_theme_mod( 'fy_form_reservation_subject', esc_html__( 'Reservation', 'forqy' ) );
		// Content
		$content = get_theme_mod( 'fy_form_reservation_content' );

		// Business
		$business_name    = get_theme_mod( 'fy_restaurant_name', get_bloginfo( 'name' ) );
		$business_address = get_theme_mod( 'fy_restaurant_address' );
		$business_phone   = get_theme_mod( 'fy_restaurant_phone' );
		$business_email   = get_theme_mod( 'fy_restaurant_email' );
		$business_url     = get_bloginfo( 'url' );

		// Check Data

		if ( isset( $_POST['reservation_submitted'] ) ) {

			// Date
			if ( trim( $_POST['fy_date'] ) === '' ) {
				$error_reservation        = true;
				$error_message['fy_date'] = $error_reservation_date;
			} else {
				$field_reservation_date = trim( $_POST['fy_date'] );
			}

			// Time
			if ( trim( $_POST['fy_time'] ) === '' ) {
				$error_reservation        = true;
				$error_message['fy_time'] = $error_reservation_time;
			} else {
				$field_reservation_time = trim( $_POST['fy_time'] );
			}

			// Persons
			if ( get_theme_mod( 'fy_form_reservation_persons', 1 ) ) {

				if ( trim( $_POST['fy_persons'] ) === '' ) {
					$error_reservation           = true;
					$error_message['fy_persons'] = $error_reservation_persons;
				} else {
					$field_reservation_persons = trim( $_POST['fy_persons'] );
				}
			}

			// Name
			if ( trim( $_POST['fy_name'] ) === '' ) {
				$error_reservation        = true;
				$error_message['fy_name'] = $error_reservation_name;
			} else {
				$field_reservation_name = trim( $_POST['fy_name'] );
			}

			// Phone
			if ( trim( $_POST['fy_phone'] ) === '' ) {

				if ( get_theme_mod( 'fy_form_reservation_phone_required', 0 ) == 1 ) {
					$error_message['fy_phone'] = $error_reservation_phone;
					$error_reservation         = true;
				} else {
					$field_reservation_phone = '';
				}
			} else {
				$field_reservation_phone = trim( $_POST['fy_phone'] );
			}

			// Email
			if ( trim( $_POST['fy_email'] ) === '' ) {
				$error_reservation         = true;
				$error_message['fy_email'] = $error_reservation_email;
			} else if ( ! filter_var( trim( $_POST['fy_email'] ), FILTER_VALIDATE_EMAIL ) ) {
				$error_reservation                 = true;
				$error_message['fy_email_invalid'] = $error_reservation_email_invalid;
			} else {
				$field_reservation_email = trim( $_POST['fy_email'] );
			}

			// Message
			if ( trim( $_POST['fy_message'] ) != '' ) {
				if ( function_exists( 'stripslashes' ) ) {
					$field_reservation_message = stripslashes( trim( $_POST['fy_message'] ) );
				} else {
					$field_reservation_message = trim( $_POST['fy_message'] );
				}
			} else {
				$field_reservation_message = '';
			}

			// Terms
			if ( get_theme_mod( 'fy_form_reservation_terms_page' ) ) {
				if ( ! isset( $_POST['fy_terms'] ) ) {
					$error_terms               = true;
					$error_message['fy_terms'] = $error_reservation_terms;
				}
			}

			// reCAPTCHA
			if ( has_action( 'recaptcha_print' ) ) {
				$recaptcha_is_valid = apply_filters( 'recaptcha_valid', null ) !== false;

				if ( $recaptcha_is_valid != true ) {
					$error_captcha               = true;
					$error_message['fy_captcha'] = $error_reservation_captcha;
				}
			}

			// reCAPTCHA v3
			if ( isset( $_POST['recaptcha'] ) ) {
				if ( function_exists( 'forqy_recaptcha_is_valid' ) ) {
					if ( ! forqy_recaptcha_is_valid( $_POST['recaptcha'] ) ) {
						$error_captcha               = true;
						$error_message['fy_captcha'] = $error_reservation_captcha;
					}
				}
			}

			if ( ! isset( $error_reservation ) && ! isset( $error_terms ) && ! isset( $error_captcha ) ) {

				// Insert Post
				$reservation = wp_insert_post( array(
					'post_title'  => wp_strip_all_tags( $field_reservation_name ),
					'post_type'   => 'reservation',
					'post_status' => 'publish'
				) );

				if ( isset( $field_reservation_date ) ) {
					update_post_meta( $reservation, 'fy_reservation_date', sanitize_text_field( $field_reservation_date ) );
				}
				if ( isset( $field_reservation_time ) ) {
					update_post_meta( $reservation, 'fy_reservation_time', sanitize_text_field( $field_reservation_time ) );
				}
				if ( get_theme_mod( 'fy_form_reservation_persons', 1 ) ) {

					if ( isset( $field_reservation_persons ) ) {
						update_post_meta( $reservation, 'fy_reservation_persons', sanitize_text_field( $field_reservation_persons ) );
					}
				}
				if ( isset( $field_reservation_name ) ) {
					update_post_meta( $reservation, 'fy_reservation_name', sanitize_text_field( $field_reservation_name ) );
				}
				if ( isset( $field_reservation_email ) ) {
					update_post_meta( $reservation, 'fy_reservation_email', sanitize_text_field( $field_reservation_email ) );
				}
				if ( isset( $field_reservation_phone ) ) {
					update_post_meta( $reservation, 'fy_reservation_phone', sanitize_text_field( $field_reservation_phone ) );
				}
				if ( isset( $field_reservation_message ) ) {
					update_post_meta( $reservation, 'fy_reservation_message', sanitize_text_field( $field_reservation_message ) );
				}

				update_post_meta( $reservation, 'fy_reservation_status', 'pending' );

				// Titles
				$title_date    = esc_html__( 'Date', 'forqy' );
				$title_time    = esc_html__( 'Time', 'forqy' );
				$title_persons = esc_html__( 'Guests', 'forqy' );
				$title_name    = esc_html__( 'Name', 'forqy' );
				$title_phone   = esc_html__( 'Phone', 'forqy' );
				$title_email   = esc_html__( 'Email', 'forqy' );
				$title_message = esc_html__( 'Message', 'forqy' );

				/**
				 * Construct Email
				 */

				// HTML Start
				$body = "<html>";
				// Head
				$body .= "<head>
                            <style type='text/css'>
                                body {
                                    font-size: 12px;
                                    color: #444444;
                                    text-align: left;
                                    background-color: #ffffff;
                                }
                                table {
                                    width: 100%;
                                    color: #444444;
                                    background-color: #ffffff;
                                }
                                table th,
                                table td {
                                    padding: 4px 0;
                                    font-size: 12px;
                                    text-align: left;
                                }
                                table th {
                                    width: 240px;
                                }
                                table th h1 {
                                    font-size: 28px;
                                }
                            </style>
                        </head>";
				// BODY Start
				$body .= "<body>";

				// ------------------------------
				// TABLES Start
				$body .= "<table><tr><td><table>";

				// SUBJECT
				if ( ! empty( $subject ) ) {
					$body .= "<tr><th colspan='2'><h1 style='margin: 0'>" . $subject . "</h1></th></tr>";
				}
				// CONTENT
				if ( ! empty( $content ) ) {
					$body .= "<tr><th colspan='2'><p>" . $content . "</p></th></tr>";
				}
				// DIVIDER
				$body .= "<tr><td colspan='2'><hr style='border-color: #dcdcdc; border-width: 0 0 1px'></td></tr>";

				// ------------------------------
				// DATE
				if ( isset( $field_reservation_date ) ) {
					$body .= "<tr><th>" . $title_date . "</th><td>" . $field_reservation_date . "</td></tr>";
				}
				// TIME
				if ( isset( $field_reservation_time ) ) {
					$body .= "<tr><th>" . $title_time . "</th><td>" . $field_reservation_time . "</td></tr>";
				}
				// PERSONS
				if ( isset( $field_reservation_persons ) ) {
					$body .= "<tr><th>" . $title_persons . "</th><td>" . $field_reservation_persons . "</td></tr>";
				}
				// NAME
				if ( isset( $field_reservation_name ) ) {
					$body .= "<tr><th>" . $title_name . "</th><td>" . $field_reservation_name . "</td></tr>";
				}
				// EMAIL
				if ( isset( $field_reservation_email ) ) {
					$body .= "<tr><th>" . $title_email . "</th><td>" . $field_reservation_email . "</td></tr>";
				}
				// PHONE
				if ( isset( $field_reservation_phone ) ) {
					$body .= "<tr><th>" . $title_phone . "</th><td>" . $field_reservation_phone . "</td></tr>";
				}
				// MESSAGE
				if ( isset( $field_reservation_message ) ) {
					$body .= "<tr><th>" . $title_message . "</th><td>" . $field_reservation_message . "</td></tr>";
				}
				// ------------------------------

				// DIVIDER
				$body .= "<tr><td colspan='2'><hr style='border-color: #dcdcdc; border-width: 0 0 1px'></td></tr>";

				// TABLES End
				$body .= "</table></td></tr></table>";

				// ------------------------------
				// FOOTER Start
				$body .= "<table>";
				// BUSINESS Name
				if ( ! empty( $business_name ) ) {
					$body .= "<tr><th><h2 style='margin: 0'>" . $business_name . "</h2></th></tr>";
				}
				// BUSINESS Address
				if ( ! empty( $business_address ) ) {
					$body .= "<tr><td>" . $business_address . "</td></tr>";
				}
				// BUSINESS Phone
				if ( ! empty( $business_phone ) ) {
					$body .= "<tr><td>" . $business_phone . "</td></tr>";
				}
				// BUSINESS Email
				if ( ! empty( $business_email ) ) {
					$body .= "<tr><td>" . $business_email . "</td></tr>";
				}
				// BUSINESS URL
				if ( ! empty( $business_url ) ) {
					$body .= "<tr><td>" . $business_url . "</td></tr>";
				}
				// FOOTER End
				$body .= "</table>";
				// ------------------------------

				// BODY End
				$body .= "</body>";
				// HTML End
				$body .= "</html>";

				/**
				 * Send Email
				 */

				$headers[] = 'Content-Type: text/html; charset=UTF-8';
				$headers[] = 'From: ' . $from_name . ' <' . $from_email . '>';

				if ( get_theme_mod( 'fy_form_copy_email', 1 ) != 0 ) {
					$headers[] = 'Cc: ' . $field_reservation_name . ' <' . $field_reservation_email . '>';
				}

				$headers[] = 'Reply-To: ' . $field_reservation_email;

				// Send
				wp_mail( $recipient, $subject, $body, $headers );

				$sent_reservation = true;

			}

		} ?>

        <div id="reservation-form" class="fy-form fy-form-reservation a-form a-form-reservation">

			<?php
			/**
			 * Hook: forqy_form_reservation_before
			 */
			do_action( 'forqy_form_reservation_before' );

			if ( get_theme_mod( 'fy_form_reservation_title', esc_html__( 'Book a Table', 'forqy' ) ) ) { ?>
                <div class="fy-form-header a-form-header cs-reservation-title">
                    <h2><?php echo get_theme_mod( 'fy_form_reservation_title', esc_html__( 'Book a Table', 'forqy' ) ); ?></h2>
                </div>
			<?php }

			if ( isset( $sent_reservation ) && $sent_reservation == true ) { ?>

                <div class="fy-alert a-alert fy-alert-success a-alert-success" role="alert">
                    <h5><?php echo esc_html__( 'The reservation has been successful. We will confirm your reservation as soon as possible.', 'forqy' ); ?></h5>
                </div>

			<?php } else {

				if ( isset( $error_reservation ) ) { ?>

                    <div class="fy-alert a-alert fy-alert-error a-alert-error" role="alert">
                        <h5><?php echo esc_html__( 'Sorry, an error occurred, a reservation has not been made.', 'forqy' ); ?></h5>
                    </div>

				<?php } else if ( isset( $error_terms ) ) { ?>

                    <div class="fy-alert-error a-alert-error fy-alert a-alert" role="alert">
                        <h5><?php echo $error_reservation_terms; ?></h5>
                    </div>

				<?php } else if ( isset( $error_captcha ) ) { ?>

                    <div class="fy-alert-error a-alert-error fy-alert a-alert" role="alert">
                        <h5><?php echo $error_reservation_captcha; ?></h5>
                    </div>

				<?php } ?>

                <form action="<?php the_permalink(); ?>#reservation-form" id="form-reservation" method="post">

                    <div class="fy-flex-container a-flex-container">

						<?php
						/**
						 * Date
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-datepicker fy-field-date fy-field a-field-datepicker a-field-date a-field">

                                <label for="fy_date"
                                       class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Date', 'forqy' ); ?>

                                    <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                          class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                </label>

                                <input type="text" id="fy_date" name="fy_date"
                                       class="fy-input a-input fy-input-datepicker a-input-datepicker js-datepicker<?php if ( isset( $error_message['fy_date'] ) ) { ?> fy-error a-error<?php } ?>"
                                       value="<?php if ( isset( $_POST['fy_date'] ) ) {
									       echo $_POST['fy_date'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Date', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>"
                                       aria-required="true"
                                       readonly>

								<?php if ( isset( $error_message['fy_date'] ) ) { ?>
                                    <label for="fy_date" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_date']; ?>
                                    </label>
								<?php } ?>

                            </div>
                        </div>

						<?php
						/**
						 * Time
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-time fy-field a-field-time a-field">

                                <label for="fy_time"
                                       class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Time', 'forqy' ); ?>

                                    <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                          class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                </label>

                                <input type="time" id="fy_time" name="fy_time"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_time'] ) ) { ?> fy-error a-error<?php } ?>"
                                       aria-required="true"
                                       placeholder="<?php echo esc_attr_x( 'Time', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>"
                                       value="<?php if ( isset( $_POST['fy_time'] ) ) {
									       echo $_POST['fy_time'];
								       } ?>">

								<?php if ( isset( $error_message['fy_time'] ) ) { ?>
                                    <label for="fy_time" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_time']; ?>
                                    </label>
								<?php } ?>

                            </div>
                        </div>

						<?php
						/**
						 * Persons
						 */

						if ( get_theme_mod( 'fy_form_reservation_persons', 1 ) ) { ?>

                            <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                                <div class="fy-field-persons fy-field a-field-persons a-field">

                                    <label for="fy_persons"
                                           class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
										<?php echo esc_html__( 'Guests', 'forqy' ); ?>

                                        <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                              class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                    </label>

                                    <input type="number" id="fy_persons" name="fy_persons" min="1" max="99"
                                           class="fy-input a-input<?php if ( isset( $error_message['fy_persons'] ) ) { ?> fy-error a-error<?php } ?>"
                                           value="<?php if ( isset( $_POST['fy_persons'] ) ) {
										       echo $_POST['fy_persons'];
									       } ?>"
                                           aria-required="true"
                                           placeholder="<?php echo esc_attr_x( 'Guests', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

									<?php if ( isset( $error_message['fy_persons'] ) ) { ?>
                                        <label for="fy_persons" class="fy-label-error a-label-error">
											<?php echo $error_message['fy_persons']; ?>
                                        </label>
									<?php } ?>

                                </div>
                            </div>
						<?php } ?>

                    </div>

                    <div class="fy-flex-container a-flex-container">

						<?php
						/**
						 * Name
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-name fy-field a-field-name a-field">

                                <label for="fy_name"
                                       class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Name', 'forqy' ); ?>

                                    <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                          class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                </label>

                                <input type="text" id="fy_name" name="fy_name" autocomplete="name"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_name'] ) ) { ?> fy-error a-error<?php } ?>"
                                       aria-required="true"
                                       value="<?php if ( isset( $_POST['fy_name'] ) ) {
									       echo $_POST['fy_name'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Name', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

								<?php if ( isset( $error_message['fy_name'] ) ) { ?>
                                    <label for="fy_name" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_name']; ?>
                                    </label>
								<?php } ?>

                            </div>
                        </div>

						<?php
						/**
						 * Email
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-email fy-field a-field-email a-field">

                                <label for="fy_email"
                                       class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Email', 'forqy' ); ?>

                                    <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                          class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                </label>

                                <input type="text" id="fy_email" name="fy_email" autocomplete="email"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_email'] ) || isset( $error_message['fy_email_invalid'] ) ) { ?> fy-error<?php } ?>"
                                       aria-required="true"
                                       value="<?php if ( isset( $_POST['fy_email'] ) ) {
									       echo $_POST['fy_email'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Email', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

								<?php if ( isset( $error_message['fy_email'] ) ) { ?>
                                    <label for="fy_email" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_email']; ?>
                                    </label>
								<?php }

								if ( isset( $error_message['fy_email_invalid'] ) ) { ?>
                                    <label for="fy_email" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_email_invalid']; ?>
                                    </label>
								<?php } ?>

                            </div>
                        </div>

						<?php
						/**
						 * Phone
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-phone fy-field a-field-phone a-field">

                                <label for="fy_phone"
                                       class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Phone', 'forqy' );

									if ( get_theme_mod( 'fy_form_reservation_phone_required', 0 ) == 1 ) { ?>
                                        <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                              class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
									<?php } ?>
                                </label>

                                <input type="text" id="fy_phone" name="fy_phone" autocomplete="tel"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_phone'] ) ) { ?> fy-error a-error<?php } ?>"
                                       aria-required="<?php if ( get_theme_mod( 'fy_form_reservation_phone_required', 0 ) == 1 ) { ?>true<?php } else { ?>false<?php } ?>"
                                       value="<?php if ( isset( $_POST['fy_phone'] ) ) {
									       echo $_POST['fy_phone'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Phone', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

								<?php if ( isset( $error_message['fy_phone'] ) ) { ?>
                                    <label for="fy_phone" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_phone']; ?>
                                    </label>
								<?php } ?>

                            </div>
                        </div>
                    </div>

					<?php
					/**
					 * Message
					 */ ?>

                    <div class="fy-field-message fy-field a-field-message a-field">

                        <label for="fy_message"
                               class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_reservation_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
							<?php echo esc_html__( 'Message', 'forqy' ); ?>
                        </label>

                        <textarea id="fy_message" name="fy_message"
                                  class="fy-input a-input fy-textarea a-textarea<?php if ( isset( $error_message['fy_message'] ) ) { ?> fy-error a-error<?php } ?>"
                                  placeholder="<?php echo esc_attr_x( 'Message', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>"><?php if ( isset( $_POST['fy_message'] ) ) {
								echo trim( $_POST['fy_message'] );
							} ?></textarea>

                    </div>

					<?php
					/**
					 * Terms
					 */

					if ( get_theme_mod( 'fy_form_reservation_terms_page' ) ) { ?>
                        <div class="fy-form-terms a-form-terms fy-field-checkbox a-field-checkbox">
                            <label for="fy_terms" class="fy-label a-label<?php if ( isset( $error_message['fy_terms'] ) ) { ?> fy-error a-error<?php } ?>">
                                <input type="checkbox" id="fy_terms" name="fy_terms" class="<?php if ( isset( $error_message['fy_terms'] ) ) { ?> fy-error a-error<?php } ?>">

								<?php
								/* translators: %s link to the terms and conditions page */
                                echo sprintf( __( 'I&rsquo;ve read and accept the <a href="%s" target="_blank" rel="noopener" class="fy-form-terms-link a-form-terms-link">terms and conditions</a>', 'forqy' ), get_permalink( get_theme_mod( 'fy_form_reservation_terms_page' ) ) ); ?>

                                <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                      class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                            </label>
                        </div>
					<?php }

					/**
					 * reCAPTCHA - WordPress ReCaptcha Integration Plugin [https://wordpress.org/plugins/wp-recaptcha-integration/]
					 * TODO Remove - reCAPTCHA v3 hooked to 'forqy_form_reservation_before_submit'
					 */

					if ( has_action( 'recaptcha_print' ) ) { ?>
                        <div class="fy-form-recaptcha a-form-recaptcha">
							<?php do_action( 'recaptcha_print' ); ?>
                        </div>
					<?php }

					/**
					 * Before submit
					 *
					 * Hook: forqy_form_reservation_before_submit
					 * @hooked forqy_recaptcha_input - 5
					 */
					do_action( 'forqy_form_reservation_before_submit' );

					if ( get_theme_mod( 'fy_form_reservation_before_button' ) ) { ?>
                        <div class="fy-form-before-submit a-form-before-submit fy-form-content fy-content a-form-content a-content">
							<?php echo do_shortcode( wp_kses_post( get_theme_mod( 'fy_form_reservation_before_button' ) ) ); ?>
                        </div>
					<?php }

					/**
					 * Submit
					 */ ?>

                    <div class="fy-form-submit a-form-submit">

                        <input type="hidden" name="reservation_submitted" id="reservation_submitted" value="true">

                        <button type="submit" name="button-submit"
                                class="fy-button a-button fy-button-accent a-button-accent">
							<?php echo get_theme_mod( 'fy_form_reservation_button', esc_html__( 'Make a reservation', 'forqy' ) ); ?>
                        </button>

                    </div>

                </form>

			<?php }

			/**
			 * Hook: forqy_form_reservation_after
			 * @hooked forqy_recaptcha_debug - 5
			 */
			do_action( 'forqy_form_reservation_after' );
			?>

        </div>

	<?php }

}

if ( ! function_exists( 'forqy_form_reservation_scripts' ) ) {

	/**
	 * Reservation Form Scripts
	 */
	function forqy_form_reservation_scripts() {

		// Enqueue jQuery UI Datepicker
		wp_enqueue_script( 'jquery-ui-datepicker' );

		// Init jQuery UI Datepicker

		// Date Format
		$date_format = esc_js( get_theme_mod( 'fy_form_reservation_date_format', 'mm/dd/yy' ) );

		// Date Max - Add quotes if not null
		$date_max_default = '+3m';
		$date_max         = get_theme_mod( 'fy_form_reservation_max_date' ) === 'null' ? get_theme_mod( 'fy_form_reservation_max_date' ) : '"' . esc_js( get_theme_mod( 'fy_form_reservation_max_date', $date_max_default ) ) . '"';

		// Script
		$datepicker = '
		    (function ($) {
                "use strict";

                $(".js-datepicker").datepicker({
                    firstDay: 1,
                    dateFormat: "' . $date_format . '",
                    maxDate: ' . $date_max . ',
                    minDate: "0",
                    beforeShow: function () {
                        $("#ui-datepicker-div").addClass("fy-datepicker");
                    }
                });

            }(jQuery));
		';

		wp_add_inline_script( 'jquery-ui-datepicker', $datepicker );

	}

	add_action( 'wp_enqueue_scripts', 'forqy_form_reservation_scripts', 50 );

}
