<?php

/*

Contact Form

*/

if ( ! function_exists( 'forqy_form_contact' ) ) {

	function forqy_form_contact() {

		// Error Messages
		$error_contact_name          = esc_html__( 'Please fill in your name.', 'forqy' );
		$error_contact_email         = esc_html__( 'Please fill in your email address.', 'forqy' );
		$error_contact_email_invalid = esc_html__( 'Please fill in the valid email address.', 'forqy' );
		$error_contact_phone         = esc_html__( 'Please fill in your phone number.', 'forqy' );
		$error_contact_message       = esc_html__( 'Please fill in your message.', 'forqy' );
		$error_contact_terms         = esc_html__( 'Please accept our terms and conditions.', 'forqy' );
		$error_contact_captcha       = esc_html__( 'Please verify the captcha.', 'forqy' );

		// From
		$from_name  = get_theme_mod( 'fy_form_from_name', get_bloginfo( 'name' ) );
		$from_email = get_theme_mod( 'fy_form_from_email', get_option( 'admin_email' ) );
		// Recipient
		$recipient_admin = get_theme_mod( 'fy_form_contact_email', get_option( 'admin_email' ) );
		$recipient       = array( $recipient_admin );
		// Subject
		$subject = get_theme_mod( 'fy_form_contact_subject', esc_html__( 'Contact Form', 'forqy' ) );
		// Content
		$content = get_theme_mod( 'fy_form_contact_content' );

		// Check data

		if ( isset( $_POST['contact_submitted'] ) ) {

			// Name
			if ( trim( $_POST['fy_name'] ) === '' ) {
				$error_contact            = true;
				$error_message['fy_name'] = $error_contact_name;
			} else {
				$field_contact_name = trim( $_POST['fy_name'] );
			}

			// Email
			if ( trim( $_POST['fy_email'] ) === '' ) {
				$error_contact             = true;
				$error_message['fy_email'] = $error_contact_email;
			} else if ( ! filter_var( trim( $_POST['fy_email'] ), FILTER_VALIDATE_EMAIL ) ) {
				$error_contact                     = true;
				$error_message['fy_email_invalid'] = $error_contact_email_invalid;
			} else {
				$field_contact_email = trim( $_POST['fy_email'] );
			}

			// Phone
			if ( trim( $_POST['fy_phone'] ) === '' ) {

				if ( get_theme_mod( 'fy_form_contact_phone_required', 0 ) == 1 ) {
					$error_contact             = true;
					$error_message['fy_phone'] = $error_contact_phone;
				} else {
					$field_contact_phone = '';
				}
			} else {
				$field_contact_phone = trim( $_POST['fy_phone'] );
			}

			// Message
			if ( trim( $_POST['fy_message'] ) === '' ) {
				$error_contact               = true;
				$error_message['fy_message'] = $error_contact_message;
			} else {
				if ( function_exists( 'stripslashes' ) ) {
					$field_contact_message = stripslashes( trim( $_POST['fy_message'] ) );
				} else {
					$field_contact_message = trim( $_POST['fy_message'] );
				}
			}

			// Terms
			if ( get_theme_mod( 'fy_form_contact_terms_page' ) ) {
				if ( ! isset( $_POST['fy_terms'] ) ) {
					$error_terms               = true;
					$error_message['fy_terms'] = $error_contact_terms;
				}
			}

			// reCAPTCHA
			if ( has_action( 'recaptcha_print' ) ) {
				$recaptcha_is_valid = apply_filters( 'recaptcha_valid', null ) !== false;

				if ( $recaptcha_is_valid != true ) {
					$error_captcha               = true;
					$error_message['fy_captcha'] = $error_contact_captcha;
				}
			}

			// reCAPTCHA v3
			if ( isset( $_POST['recaptcha'] ) ) {
				if ( function_exists( 'forqy_recaptcha_is_valid' ) ) {
					if ( ! forqy_recaptcha_is_valid( $_POST['recaptcha'] ) ) {
						$error_captcha               = true;
						$error_message['fy_captcha'] = $error_contact_captcha;
					}
				}
			}

			if ( ! isset( $error_contact ) && ! isset( $error_terms ) && ! isset( $error_captcha ) ) {

				$title_name    = esc_html__( 'Name', 'forqy' );
				$title_phone   = esc_html__( 'Phone number', 'forqy' );
				$title_email   = esc_html__( 'Email address', 'forqy' );
				$title_message = esc_html__( 'Message', 'forqy' );

				// Email
				$body = "
					<html>
					<head>
			            <style type='text/css'>
			                body {
			                    font-size: 14px;
			                    color: #333333;
			                    text-align: left;
			                    background-color: #ffffff;
			                }
			                table {
			                    width: 100%;
			                    background-color: #ffffff;
			                }
			                table th,
			                table td {
			                    padding: 5px 0;
			                    font-size: 14px;
			                    text-align: left;
			                }
			                table th {
			                    width: 200px;
			                }
			                table th h1 {
			                    font-size: 30px;
			                }
			            </style>
					</head>
					<body>
			            <table>
			                <tr>
			                    <td>
			                        <table align='left'>
			                            <tr>
			                                <th colspan='2' align='left'>
			                                    <h1>$subject</h1>
			                                </th>
			                            </tr>
			                            <tr>
			                                <th colspan='2' align='left'>
			                                    <p style='font-weight: normal'>$content</p>
			                                </th>
			                            </tr>
			                            <tr>
			                                <th align='left'>$title_name</th>
			                                <td align='left'>$field_contact_name</td>
			                            </tr>
			                            <tr>
			                                <th align='left'>$title_phone</th>
			                                <td align='left'>$field_contact_phone</td>
			                            </tr>
			                            <tr>
			                                <th align='left'>$title_email</th>
			                                <td align='left'>$field_contact_email</td>
			                            </tr>
			                            <tr>
			                                <th align='left'>$title_message</th>
			                                <td align='left'>$field_contact_message</td>
			                            </tr>
			                        </table>
			                    </td>
			                </tr>
			            </table>
			        </body>
					</html>
				";

				// Headers
				$headers[] = 'Content-Type: text/html; charset=UTF-8';
				$headers[] = 'From: ' . $from_name . ' <' . $from_email . '>';
				if ( get_theme_mod( 'fy_form_copy_email', 1 ) != 0 ) {
					$headers[] = 'Cc: ' . $field_contact_name . ' <' . $field_contact_email . '>';
				}
				$headers[] = 'Reply-To: ' . $field_contact_email;

				// Send email
				wp_mail( $recipient, $subject, $body, $headers );

				$sent_contact = true;

			}

		} ?>

        <div id="contact-form" class="fy-form fy-form-contact a-form a-form-contact">

			<?php
			/**
			 * Hook: forqy_form_contact_before
			 */
			do_action( 'forqy_form_contact_before' );

			if ( get_theme_mod( 'fy_form_contact_title', esc_html__( 'Contact Us', 'forqy' ) ) != '' ) { ?>
                <div class="fy-form-header a-form-header cs-contact-title">
                    <h2><?php echo get_theme_mod( 'fy_form_contact_title', esc_html__( 'Contact Us', 'forqy' ) ); ?></h2>
                </div>
			<?php }

			if ( isset( $sent_contact ) && $sent_contact == true ) { ?>

                <div class="fy-alert-success a-alert-success fy-alert a-alert">
                    <h5><?php echo esc_html__( 'Email has been sent. We will contact you as soon as possible.', 'forqy' ); ?></h5>
                </div>

			<?php } else {

				if ( isset( $error_contact ) ) { ?>

                    <div class="fy-alert-error a-alert-error fy-alert a-alert">
                        <h5><?php echo esc_html__( 'Sorry, an error occurred, email has not been sent.', 'forqy' ); ?></h5>
                    </div>

				<?php } else if ( isset( $error_terms ) ) { ?>

                    <div class="fy-alert-error a-alert-error fy-alert a-alert">
                        <h5><?php echo $error_contact_terms; ?></h5>
                    </div>

				<?php } else if ( isset( $error_captcha ) ) { ?>

                    <div class="fy-alert-error a-alert-error fy-alert a-alert">
                        <h5><?php echo $error_contact_captcha; ?></h5>
                    </div>

				<?php } ?>

                <form action="<?php the_permalink(); ?>#contact-form" id="form-contact" method="post">

                    <div class="fy-flex-container a-flex-container">

						<?php
						/**
						 * Name
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-name fy-field a-field-name a-field">

                                <label for="fy_name" class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_contact_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Name', 'forqy' ); ?>

                                    <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                          class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                </label>

                                <input type="text" id="fy_name" name="fy_name" autocomplete="name"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_name'] ) ) { ?> fy-error a-error<?php } ?>"
                                       value="<?php if ( isset( $_POST['fy_name'] ) ) {
									       echo $_POST['fy_name'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Name', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

								<?php if ( isset( $error_message['fy_name'] ) ) { ?>
                                    <label for="fy_name" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_name']; ?>
                                    </label>
								<?php } ?>
                            </div>
                        </div>

						<?php
						/**
						 * Email
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-email fy-field a-field-email a-field">

                                <label for="fy_email" class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_contact_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Email', 'forqy' ); ?>

                                    <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                          class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                                </label>

                                <input type="text" id="fy_email" name="fy_email" autocomplete="email"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_email'] ) || isset( $error_message['fy_email_invalid'] ) ) { ?> fy-error a-error<?php } ?>"
                                       value="<?php if ( isset( $_POST['fy_email'] ) ) {
									       echo $_POST['fy_email'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Email', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

								<?php if ( isset( $error_message['fy_email'] ) ) { ?>
                                    <label for="fy_email" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_email']; ?></label>
								<?php }

								if ( isset( $error_message['fy_email_invalid'] ) ) { ?>
                                    <label for="fy_email" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_email_invalid']; ?>
                                    </label>
								<?php } ?>
                            </div>
                        </div>

						<?php
						/**
						 * Phone
						 */ ?>

                        <div class="fy-flex-column-auto a-flex-column-auto fy-flex-column-phone-100 a-flex-column-phone-100">
                            <div class="fy-field-phone fy-field a-field-phone a-field">

                                <label for="fy_phone" class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_contact_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
									<?php echo esc_html__( 'Phone', 'forqy' ); ?>

									<?php if ( get_theme_mod( 'fy_form_contact_phone_required', 0 ) == 1 ) { ?>
                                        <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                              class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
									<?php } ?>
                                </label>

                                <input type="text" id="fy_phone" name="fy_phone" autocomplete="tel"
                                       class="fy-input a-input<?php if ( isset( $error_message['fy_phone'] ) ) { ?> fy-error a-error<?php } ?>"
                                       value="<?php if ( isset( $_POST['fy_phone'] ) ) {
									       echo $_POST['fy_phone'];
								       } ?>"
                                       placeholder="<?php echo esc_attr_x( 'Phone', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>">

								<?php if ( isset( $error_message['fy_phone'] ) ) { ?>
                                    <label for="fy_phone" class="fy-label-error a-label-error">
										<?php echo $error_message['fy_phone']; ?>
                                    </label>
								<?php } ?>

                            </div>
                        </div>

                    </div>

					<?php
					/**
					 * Message
					 */ ?>

                    <div class="fy-field-message fy-field a-field-message a-field">

                        <label for="fy_message" class="fy-label a-label<?php if ( get_theme_mod( 'fy_form_contact_label' ) == 'disabled' ) { ?> screen-reader-text<?php } ?>">
							<?php echo esc_html__( 'Message', 'forqy' ); ?>

                            <abbr title="<?php echo esc_attr__( 'Required', 'forqy' ); ?>"
                                  class="fy-required a-required"><?php echo esc_html__( '*', 'forqy' ); ?></abbr>
                        </label>

                        <textarea id="fy_message" name="fy_message"
                                  class="fy-input a-input fy-textarea a-textarea<?php if ( isset( $error_message['fy_message'] ) ) { ?> fy-error a-error<?php } ?>"
                                  placeholder="<?php echo esc_attr_x( 'Message', 'placeholder', 'forqy' ) . ' ' . esc_attr_x( '...', 'placeholder', 'forqy' ); ?>"><?php if ( isset( $_POST['fy_message'] ) ) {
								echo trim( $_POST['fy_message'] );
							} ?></textarea>

						<?php if ( isset( $error_message['fy_message'] ) ) { ?>
                            <label for="fy_message" class="fy-label-error a-label-error">
								<?php echo $error_message['fy_message']; ?>
                            </label>
						<?php } ?>
                    </div>

					<?php
					/**
					 * Terms
					 */

					if ( get_theme_mod( 'fy_form_contact_terms_page' ) ) { ?>
                        <div class="fy-form-terms a-form-terms fy-field-checkbox a-field-checkbox">
                            <label for="fy_terms" class="fy-label a-label<?php if ( isset( $error_message['fy_terms'] ) ) { ?> fy-error a-error<?php } ?>">
                                <input type="checkbox" id="fy_terms" name="fy_terms" class="<?php if ( isset( $error_message['fy_terms'] ) ) { ?> fy-error a-error<?php } ?>">

								<?php
                                /* translators: %s link to the terms and conditions page */
                                echo sprintf( __( 'I&rsquo;ve read and accept the <a href="%s" target="_blank" rel="noopener" class="fy-form-terms-link a-form-terms-link">terms and conditions</a>', 'forqy' ), get_permalink( get_theme_mod( 'fy_form_contact_terms_page' ) ) ); ?>

                                <abbr title="<?php esc_attr_e( 'Required', 'forqy' ); ?>"
                                      class="fy-required a-required"><?php esc_html_e( '*', 'forqy' ); ?></abbr>
                            </label>
                        </div>
					<?php }

					/**
					 * reCAPTCHA - WordPress ReCaptcha Integration Plugin [https://wordpress.org/plugins/wp-recaptcha-integration/]
					 * TODO Remove - reCAPTCHA v3 hooked to 'forqy_form_reservation_before_submit'
					 */

					if ( has_action( 'recaptcha_print' ) ) { ?>
                        <div class="fy-form-recaptcha a-form-recaptcha">
							<?php do_action( 'recaptcha_print' ); ?>
                        </div>
					<?php }

					/**
					 * Before Submit
					 *
					 * Hook: forqy_form_contact_before_submit
					 * @hooked forqy_recaptcha_input - 5
					 */
					do_action( 'forqy_form_contact_before_submit' );

					if ( get_theme_mod( 'fy_form_contact_before_button' ) ) { ?>
                        <div class="fy-form-before-submit a-form-before-submit fy-form-content fy-content a-form-content a-content">
							<?php echo do_shortcode( wp_kses_post( get_theme_mod( 'fy_form_contact_before_button' ) ) ); ?>
                        </div>
					<?php }

					/**
					 * Submit
					 */ ?>

                    <div class="fy-form-submit a-form-submit">

                        <input type="hidden" name="contact_submitted" id="contact_submitted" value="true">

                        <button type="submit" name="button-submit"
                                class="fy-button a-button fy-button-accent a-button-accent">
							<?php echo get_theme_mod( 'fy_form_contact_button', esc_html__( 'Send', 'forqy' ) ); ?>
                        </button>

                    </div>

                </form>

			<?php }

			/**
			 * Hook: forqy_form_contact_after
			 * @hooked forqy_recaptcha_debug - 5
			 */
			do_action( 'forqy_form_contact_after' );
			?>

        </div>

	<?php }

}
