<?php

/*

Customize Forms

*/

if ( ! function_exists( 'forqy_forms_add_section_forms' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_section_forms( $wp_customize ) {

		$wp_customize->add_section( 'forms', array(
			'title'    => esc_html_x( 'Forms', 'forms', 'forqy' ),
			'priority' => 180,
		) );

	}

	add_action( 'customize_register', 'forqy_forms_add_section_forms' );

}

if ( ! function_exists( 'forqy_forms_add_settings_forms' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_settings_forms( $wp_customize ) {

		$wp_customize->add_setting( 'fy_form_from_name', array(
			'default'           => get_bloginfo( 'name' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_from_email', array(
			'default'           => get_option( 'admin_email' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_copy_email', array(
			'default'           => 1,
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'forqy_forms_add_settings_forms', 10 );

}

if ( ! function_exists( 'forqy_forms_add_controls_forms' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_controls_forms( $wp_customize ) {

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_from_name', array(
			'label'    => esc_html_x( 'Name for sending emails', 'forms', 'forqy' ),
			'settings' => 'fy_form_from_name',
			'section'  => 'forms',
			'priority' => 1,
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_from_email', array(
			'label'       => esc_html_x( 'Email for sending emails', 'forms', 'forqy' ),
			'description' => esc_html_x( 'Please note if you are sending using an email provider (Gmail, Yahoo, Hotmail, Outlook.com, etc) this setting should be your email address for that account.', 'forms', 'forqy' ),
			'settings'    => 'fy_form_from_email',
			'section'     => 'forms',
			'priority'    => 1,
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_copy_email', array(
			'label'    => esc_html_x( 'Send email copy to the user?', 'forms', 'forqy' ),
			'settings' => 'fy_form_copy_email',
			'type'     => 'checkbox',
			'section'  => 'forms',
			'priority' => 1,
		) ) );

	}

	add_action( 'customize_register', 'forqy_forms_add_controls_forms', 10 );

}
