<?php

/*

Customize Reservation Form

*/

if ( ! function_exists( 'forqy_forms_add_settings_reservation_form' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_settings_reservation_form( $wp_customize ) {

		$wp_customize->add_setting( 'fy_form_reservation_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Form

		// Title
		$wp_customize->add_setting( 'fy_form_reservation_title', array(
			'default'           => esc_html__( 'Book a Table', 'forqy' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->selective_refresh->add_partial( 'fy_form_reservation_title', array(
			'selector' => '.cs-reservation-title'
		) );

		// Width
		$wp_customize->add_setting( 'fy_form_reservation_width', array(
			'default'           => 'auto',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Label
		$wp_customize->add_setting( 'fy_form_reservation_label', array(
			'default'           => 'enabled',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Date
		$wp_customize->add_setting( 'fy_form_reservation_subheading_date', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_date_format', array(
			'default'           => 'mm/dd/yy',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_max_date', array(
			'default'           => '+3m',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Persons
		$wp_customize->add_setting( 'fy_form_reservation_subheading_persons', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_persons', array(
			'default'           => 1,
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Phone
		$wp_customize->add_setting( 'fy_form_reservation_subheading_phone', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_phone_required', array(
			'default'           => 0,
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Terms
		$wp_customize->add_setting( 'fy_form_reservation_subheading_terms', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_terms_page', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Button
		$wp_customize->add_setting( 'fy_form_reservation_subheading_button', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_before_button', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_button', array(
			'default'           => esc_html__( 'Make a reservation', 'forqy' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Email
		$wp_customize->add_setting( 'fy_form_reservation_subheading_email', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_email', array(
			'default'           => get_option( 'admin_email' ),
			'sanitize_callback' => 'sanitize_email',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_subject', array(
			'default'           => esc_html_x( 'Reservation', 'email', 'forqy' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_reservation_content', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'forqy_forms_add_settings_reservation_form', 30 );

}

if ( ! function_exists( 'forqy_forms_add_controls_reservation_form' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_controls_reservation_form( $wp_customize ) {

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_form_reservation_heading', array(
				'label'   => esc_html_x( 'Reservation Form', 'forms', 'forqy' ),
				'type'    => 'heading',
				'section' => 'forms',
			) ) );
		}

		// Form

		// Title
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_title', array(
			'label'    => esc_html_x( 'Title', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_title',
			'section'  => 'forms',
		) ) );

		// Width
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_width', array(
			'label'    => esc_html_x( 'Width', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_width',
			'section'  => 'forms',
			'type'     => 'select',
			'choices'  => array(
				'auto' => esc_html_x( 'Auto', 'option', 'forqy' ),
				'50'   => esc_html_x( '50%', 'option', 'forqy' ),
				'75'   => esc_html_x( '75%', 'option', 'forqy' ),
				'100'  => esc_html_x( '100%', 'option', 'forqy' ),
			),
		) ) );

		// Label
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_label', array(
			'label'    => esc_html_x( 'Labels', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_label',
			'section'  => 'forms',
			'type'     => 'select',
			'choices'  => array(
				'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
				'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
			),
		) ) );

		// Date
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_reservation_subheading_date', array(
				'label'   => esc_html_x( 'Date Field', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_date_format', array(
			'label'    => esc_html_x( 'Date Format', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_date_format',
			'section'  => 'forms',
			'type'     => 'select',
			'choices'  => array(
				'dd mm yy' => 'DD MM YY',
				'dd/mm/yy' => 'DD/MM/YY',
				'dd-mm-yy' => 'DD-MM-YY',
				'dd.mm.yy' => 'DD.MM.YY',
				'mm dd yy' => 'MM DD YY',
				'mm/dd/yy' => 'MM/DD/YY',
				'mm-dd-yy' => 'MM-DD-YY',
				'mm.dd.yy' => 'MM.DD.YY',
				'yy mm dd' => 'YY MM DD',
				'yy/mm/dd' => 'YY/MM/DD',
				'yy-mm-dd' => 'YY-MM-DD',
				'yy.mm.dd' => 'YY.MM.DD',
				'yy dd mm' => 'YY DD MM',
				'yy/dd/mm' => 'YY/DD/MM',
				'yy-dd-mm' => 'YY-DD-MM',
				'yy.dd.mm' => 'YY.DD.MM',
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_max_date', array(
			'label'    => esc_html_x( 'Maximum Date', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_max_date',
			'section'  => 'forms',
			'type'     => 'select',
			'choices'  => array(
				'+1w'  => esc_html_x( '1 week', 'option', 'forqy' ),
				'+2w'  => esc_html_x( '2 weeks', 'option', 'forqy' ),
				'+3w'  => esc_html_x( '3 weeks', 'option', 'forqy' ),
				'+1m'  => esc_html_x( '1 month', 'option', 'forqy' ),
				'+2m'  => esc_html_x( '2 months', 'option', 'forqy' ),
				'+3m'  => esc_html_x( '3 months', 'option', 'forqy' ),
				'+6m'  => esc_html_x( '6 months', 'option', 'forqy' ),
				'null' => esc_html_x( 'Unlimited', 'option', 'forqy' ),
			),
		) ) );

		// Persons
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_reservation_subheading_persons', array(
				'label'   => esc_html_x( 'Guests Field', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_persons', array(
			'label'    => esc_html_x( 'Enabled?', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_persons',
			'type'     => 'checkbox',
			'section'  => 'forms',
		) ) );

		// Phone
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_reservation_subheading_phone', array(
				'label'   => esc_html_x( 'Phone Field', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_phone_required', array(
			'label'    => esc_html_x( 'Required?', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_phone_required',
			'type'     => 'checkbox',
			'section'  => 'forms',
		) ) );

		// Terms
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_reservation_subheading_terms', array(
				'label'   => esc_html_x( 'Terms and Conditions', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_terms_page', array(
			'label'       => esc_html_x( 'Terms Page', 'forms', 'forqy' ),
			'description' => esc_html_x( 'If you define a "Terms" page the user will be asked if they accept them.', 'forms', 'forqy' ),
			'settings'    => 'fy_form_reservation_terms_page',
			'type'        => 'dropdown-pages',
			'section'     => 'forms',
		) ) );

		// Button
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_reservation_subheading_button', array(
				'label'   => esc_html_x( 'Button', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_before_button', array(
			'label'    => esc_html_x( 'Before Button', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_before_button',
			'type'     => 'textarea',
			'section'  => 'forms',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_button', array(
			'label'    => esc_html_x( 'Button', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_button',
			'section'  => 'forms',
		) ) );

		// Email

		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_reservation_subheading_email', array(
				'label'   => esc_html_x( 'Email', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_email', array(
			'label'    => esc_html_x( 'Receive Emails to:', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_email',
			'section'  => 'forms',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_subject', array(
			'label'    => esc_html_x( 'Email Subject', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_subject',
			'section'  => 'forms',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_reservation_content', array(
			'label'    => esc_html_x( 'Email Content', 'forms', 'forqy' ),
			'settings' => 'fy_form_reservation_content',
			'type'     => 'textarea',
			'section'  => 'forms',
		) ) );

	}

	add_action( 'customize_register', 'forqy_forms_add_controls_reservation_form', 30 );

}
