<?php

/*

Customize Contact Form

*/

if ( ! function_exists( 'forqy_forms_add_settings_contact_form' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_settings_contact_form( $wp_customize ) {

		$wp_customize->add_setting( 'fy_form_contact_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Form

		// Title
		$wp_customize->add_setting( 'fy_form_contact_title', array(
			'default'           => esc_html__( 'Contact Us', 'forqy' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->selective_refresh->add_partial( 'fy_form_contact_title', array(
			'selector' => '.cs-contact-title'
		) );

		// Width
		$wp_customize->add_setting( 'fy_form_contact_width', array(
			'default'           => 'auto',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Label
		$wp_customize->add_setting( 'fy_form_contact_label', array(
			'default'           => 'enabled',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Phone
		$wp_customize->add_setting( 'fy_form_contact_subheading_phone', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_contact_phone_required', array(
			'default'           => 0,
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Terms
		$wp_customize->add_setting( 'fy_form_contact_subheading_terms', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_contact_terms_page', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Button
		$wp_customize->add_setting( 'fy_form_contact_subheading_button', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_contact_before_button', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_contact_button', array(
			'default'           => esc_html__( 'Send', 'forqy' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Email

		$wp_customize->add_setting( 'fy_form_contact_subheading_email', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_contact_email', array(
			'default'           => get_option( 'admin_email' ),
			'sanitize_callback' => 'sanitize_email',
		) );
		$wp_customize->add_setting( 'fy_form_contact_subject', array(
			'default'           => esc_html__( 'Contact Form', 'forqy' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_form_contact_content', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'forqy_forms_add_settings_contact_form', 20 );

}

if ( ! function_exists( 'forqy_forms_add_controls_contact_form' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_forms_add_controls_contact_form( $wp_customize ) {

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_form_contact_heading', array(
				'label'   => esc_html_x( 'Contact Form', 'forms', 'forqy' ),
				'type'    => 'heading',
				'section' => 'forms',
			) ) );
		}

		// Form

		// Title
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_title', array(
			'label'    => esc_html_x( 'Title', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_title',
			'section'  => 'forms',
		) ) );

		// Width
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_width', array(
			'label'    => esc_html_x( 'Width', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_width',
			'section'  => 'forms',
			'type'     => 'select',
			'choices'  => array(
				'auto' => esc_html_x( 'Auto', 'option', 'forqy' ),
				'50'   => esc_html_x( '50%', 'option', 'forqy' ),
				'75'   => esc_html_x( '75%', 'option', 'forqy' ),
				'100'  => esc_html_x( '100%', 'option', 'forqy' ),
			),
		) ) );

		// Label
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_label', array(
			'label'    => esc_html_x( 'Labels', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_label',
			'section'  => 'forms',
			'type'     => 'select',
			'choices'  => array(
				'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
				'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
			),
		) ) );

		// Phone
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_contact_subheading_phone', array(
				'label'   => esc_html_x( 'Phone Field', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_phone_required', array(
			'label'    => esc_html_x( 'Required?', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_phone_required',
			'type'     => 'checkbox',
			'section'  => 'forms',
		) ) );

		// Terms
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_contact_subheading_terms', array(
				'label'   => esc_html_x( 'Terms and Conditions', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_terms_page', array(
			'label'       => esc_html_x( 'Terms Page', 'forms', 'forqy' ),
			'description' => esc_html_x( 'If you define a "Terms" page the user will be asked if they accept them.', 'forms', 'forqy' ),
			'settings'    => 'fy_form_contact_terms_page',
			'type'        => 'dropdown-pages',
			'section'     => 'forms',
		) ) );

		// Button
		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_contact_subheading_button', array(
				'label'   => esc_html_x( 'Button', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_before_button', array(
			'label'    => esc_html_x( 'Before Button', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_before_button',
			'type'     => 'textarea',
			'section'  => 'forms',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_button', array(
			'label'    => esc_html_x( 'Button', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_button',
			'section'  => 'forms',
		) ) );

		// Email

		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_form_contact_subheading_email', array(
				'label'   => esc_html_x( 'Email', 'forms', 'forqy' ),
				'type'    => 'subheading',
				'section' => 'forms',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_email', array(
			'label'    => esc_html_x( 'Receive Emails to:', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_email',
			'section'  => 'forms',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_subject', array(
			'label'    => esc_html_x( 'Email Subject', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_subject',
			'section'  => 'forms',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_form_contact_content', array(
			'label'    => esc_html_x( 'Email Content', 'forms', 'forqy' ),
			'settings' => 'fy_form_contact_content',
			'type'     => 'textarea',
			'section'  => 'forms',
		) ) );

	}

	add_action( 'customize_register', 'forqy_forms_add_controls_contact_form', 20 );

}
