<?php

/*

FORQY

*/

/*
====================================================================================================
Fields
====================================================================================================
*/

if ( ! function_exists( 'forqy_options_forqy_fields' ) ) {

	function forqy_options_forqy_fields() {

		// register a new setting for page
		register_setting( 'forqy_posts', 'forqy_post' );

		// register a new section in the page
		add_settings_section(
			'forqy_post_types',
			__( 'Post Types', 'forqy' ), 'forqy_options_forqy_cb',
			'forqy_posts'
		);

		// register fields

		// portfolio
		add_settings_field(
			'forqy_post_portfolio',
			__( 'Portfolio', 'forqy' ), 'forqy_options_forqy_field_select_post',
			'forqy_posts',
			'forqy_post_types',
			[
				'label_for' => 'forqy_post_portfolio',
				'class'     => 'forqy-post-portfolio',
			]
		);

		// menu
		add_settings_field(
			'forqy_post_menu',
			__( 'Menu', 'forqy' ), 'forqy_options_forqy_field_select_post',
			'forqy_posts',
			'forqy_post_types',
			[
				'label_for' => 'forqy_post_menu',
				'class'     => 'forqy-post-menu',
			]
		);

		// album
		add_settings_field(
			'forqy_post_album',
			__( 'Albums', 'forqy' ), 'forqy_options_forqy_field_select_post',
			'forqy_posts',
			'forqy_post_types',
			[
				'label_for' => 'forqy_post_album',
				'class'     => 'forqy-post-album',
			]
		);

		// event
		add_settings_field(
			'forqy_post_event',
			__( 'Events', 'forqy' ), 'forqy_options_forqy_field_select_post',
			'forqy_posts',
			'forqy_post_types',
			[
				'label_for' => 'forqy_post_event',
				'class'     => 'forqy-post-event',
			]
		);

		// gallery
		add_settings_field(
			'forqy_post_gallery',
			__( 'Gallery', 'forqy' ), 'forqy_options_forqy_field_select_post',
			'forqy_posts',
			'forqy_post_types',
			[
				'label_for' => 'forqy_post_gallery',
				'class'     => 'forqy-post-gallery',
			]
		);

		// reservation
		add_settings_field(
			'forqy_post_reservation',
			__( 'Reservations', 'forqy' ), 'forqy_options_forqy_field_select_post',
			'forqy_posts',
			'forqy_post_types',
			[
				'label_for' => 'forqy_post_reservation',
				'class'     => 'forqy-post-reservation',
			]
		);

	}

	add_action( 'admin_init', 'forqy_options_forqy_fields' );

}

/*
----------------------------------------------------------------------------------------------------
Field - Select Post
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_options_forqy_field_select_post' ) ) {

	function forqy_options_forqy_field_select_post( $args ) {
		// get the value of the setting we've registered with register_setting()
		$options = get_option( 'forqy_post' );
		// output the field
		?>
        <select id="<?php echo esc_attr( $args['label_for'] ); ?>"
                name="forqy_post[<?php echo esc_attr( $args['label_for'] ); ?>]">
            <option value="enabled" <?php echo isset( $options[ $args['label_for'] ] ) ? ( selected( $options[ $args['label_for'] ], 'enabled', false ) ) : ( '' ); ?>>
				<?php esc_html_e( 'Enabled', 'forqy' ); ?>
            </option>
            <option value="disabled" <?php echo isset( $options[ $args['label_for'] ] ) ? ( selected( $options[ $args['label_for'] ], 'disabled', false ) ) : ( '' ); ?>>
				<?php esc_html_e( 'Disabled', 'forqy' ); ?>
            </option>
        </select>
        <p class="description">
			<?php esc_html_e( 'Enable/disable the use of this post type. All data will retain.', 'forqy' ); ?>
        </p>
		<?php
	}

}

/*
====================================================================================================
Section
====================================================================================================
*/

function forqy_options_forqy_cb( $args ) {
	// add to section
	?>

    <p id="<?php echo esc_attr( $args['id'] ); ?>">
		<?php esc_html_e( 'Set up the post types used with the theme.', 'forqy' ); ?>
    </p>

	<?php
}

/*
====================================================================================================
Page HTML
====================================================================================================
*/

if ( ! function_exists( 'forqy_options_forqy_html' ) ) {

	function forqy_options_forqy_html() {

		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		// show error/update messages
		settings_errors( 'forqy_messages' );
		?>

        <div class="wrap">

			<?php
			/**
			 * forqy_action_page_before hook
			 * @hooked forqy_options_page_header - 5
			 */
			do_action( 'forqy_action_page_before' );
			?>

            <form action="options.php" method="post">
				<?php
				// output security fields for the registered setting "forqy"
				settings_fields( 'forqy_posts' );

				// output setting sections and their fields
				// (sections are registered for "forqy", each field is registered to a specific section)
				do_settings_sections( 'forqy_posts' );

				// output save settings button
				submit_button();
				?>
            </form>

			<?php
			/**
			 * forqy_action_page_after hook
			 * @hooked forqy_options_page_footer - 5
			 */
			do_action( 'forqy_action_page_after' );
			?>

        </div>
		<?php
	}

}
