<?php

/*

Header

*/

if ( ! function_exists( 'forqy_options_page_header' ) ) {

	function forqy_options_page_header() {
		global $forqy_welcome_slug;

		$current        = get_current_screen();
		$current_screen = ! empty( $current ) ? $current->id : null;
		?>

        <header id="<?php esc_attr_e( sanitize_title( get_admin_page_title() ) ); ?>" class="f-header">

            <h1>
				<?php if ( ! empty( $current ) && ( $current_screen != FORQY_PAGE_PREFIX . $forqy_welcome_slug ) ) {
					esc_html_e( get_admin_page_title() );
				} ?>
            </h1>

        </header>

		<?php

	}

	add_action( 'forqy_action_page_before', 'forqy_options_page_header', 5 );

}
