<?php
/**
 * Plugin Name:         FORQY
 * Plugin URI:          https://forqy.website/
 * Description:         The Engine of FORQY WordPress Themes
 *
 * Version:             1.2.5
 * Requires at least:   5.9
 * Requires PHP:        7.4
 *
 * Text Domain:         forqy
 * Domain Path:         /languages
 *
 * Author:              FORQY
 * Author URI:          https://forqy.website/
 *
 * License:             GPL-3.0-or-later
 */

// Prevent Direct File Access
defined( 'ABSPATH' ) or exit;

// Constants
define( 'FORQY_NAME', __( 'FORQY', 'forqy' ) ); // FORQY
define( 'FORQY_URL', 'https://forqy.website/' ); // URL

define( 'FORQY_DIR', plugin_basename( __DIR__ ) ); // PLUGIN
define( 'FORQY_DIR_FILE', plugin_basename( __FILE__ ) ); // PLUGIN/PLUGIN.php

define( 'FORQY_HOME_DIR', plugin_dir_path( __DIR__ ) . trailingslashit( FORQY_DIR ) ); // /path/to/project/wp-content/plugins/PLUGIN/
define( 'FORQY_HOME_DIR_FILE', plugin_dir_path( __DIR__ ) . FORQY_DIR_FILE ); // /path/to/project/wp-content/plugins/PLUGIN/PLUGIN.php

define( 'FORQY_PAGE_PREFIX', sanitize_title( FORQY_DIR ) . '_page_' ); // FORQY

/*
====================================================================================================
Autoload
====================================================================================================
*/

require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/autoload.php';

/*
====================================================================================================
Localization
====================================================================================================
*/

if ( ! function_exists( 'forqy_textdomain' ) ) {

	function forqy_textdomain(): void {
		load_plugin_textdomain( 'forqy', false, trailingslashit( FORQY_DIR ) . 'languages/' );
	}

	add_action( 'plugins_loaded', 'forqy_textdomain' );

}

/*
====================================================================================================
Updates
====================================================================================================
*/

require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/yahnis-elsts/plugin-update-checker/plugin-update-checker.php';

// Update Checker
if ( class_exists( 'Puc_v4_Factory' ) ) {
	$forqy_update_checker = Puc_v4_Factory::buildUpdateChecker( esc_url( 'https://plugin.forqy.website/' . FORQY_DIR . '.json' ), __FILE__ );
}

/*
====================================================================================================
FORQY
Bootstrap the FORQY for WordPress Plugin
====================================================================================================
*/

if ( ! function_exists( 'forqy' ) ) {

	function forqy() {

		// Plugin Options
		global $forqy_posts;
		$forqy_posts = get_option( 'forqy_post' );

		/**
		 * Options
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'inc/options.php';

		/**
		 * LESS
		 */
		// Compiler
		if ( ! class_exists( 'lessc' ) ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/marcusschwarz/lesserphp/lessc.inc.php';
		}
		// LESS
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/less/less.php';

		/**
		 * Metabox
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/wpmetabox/meta-box/meta-box.php';

		/**
		 * Customize
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/customize/customize.php';

		/**
		 * Types
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/types.php';

		// Video Support
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/support-video.php';

		// Slide // 30
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-slide.php';

		// Portfolio // 31
		if ( ! isset( $forqy_posts['forqy_post_portfolio'] ) || $forqy_posts['forqy_post_portfolio'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-portfolio.php';
		}
		// Menu // 32
		if ( ! isset( $forqy_posts['forqy_post_menu'] ) || $forqy_posts['forqy_post_menu'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-menu.php';
		}
		// Album // 33
		if ( ! isset( $forqy_posts['forqy_post_album'] ) || $forqy_posts['forqy_post_album'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-album.php';
		}
		// Event // 34
		if ( ! isset( $forqy_posts['forqy_post_event'] ) || $forqy_posts['forqy_post_event'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-event.php';
		}
		// Gallery // 35
		if ( ! isset( $forqy_posts['forqy_post_gallery'] ) || $forqy_posts['forqy_post_gallery'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-gallery.php';
		}
		// Reservation // 40
		if ( ! isset( $forqy_posts['forqy_post_reservation'] ) || $forqy_posts['forqy_post_reservation'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/types/type-reservation.php';
		}

		/**
		 * Forms
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/forms/forms.php';

		// Contact
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/forms/form-contact.php';
		// Customize Contact
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/forms/customize/form-contact.php';

		if ( ! isset( $forqy_posts['forqy_post_reservation'] ) || $forqy_posts['forqy_post_reservation'] != 'disabled' ) {
			// Reservation
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/forms/form-reservation.php';
			// Customize Reservation
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/forms/customize/form-reservation.php';
		}

		/**
		 * Widgets
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'inc/widgets.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widgets.php';

		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/image.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/call-to-action.php';

		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/about.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/socials.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/opening-hours.php';

		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/subpages.php';

		if ( ! isset( $forqy_posts['forqy_post_menu'] ) || $forqy_posts['forqy_post_menu'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/sections-menu.php';
		}
		if ( ! isset( $forqy_posts['forqy_post_portfolio'] ) || $forqy_posts['forqy_post_portfolio'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/categories-portfolio.php';
		}
		if ( ! isset( $forqy_posts['forqy_post_album'] ) || $forqy_posts['forqy_post_album'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/categories-album.php';
		}
		if ( ! isset( $forqy_posts['forqy_post_event'] ) || $forqy_posts['forqy_post_event'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/categories-event.php';
		}
		if ( ! isset( $forqy_posts['forqy_post_gallery'] ) || $forqy_posts['forqy_post_gallery'] != 'disabled' ) {
			require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/widgets/widget/categories-gallery.php';
		}

		/**
		 * Shortcodes
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcodes.php';

		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-forms.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-button.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-image.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-alert.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-anchor.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-flex.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-typography.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-divider.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-spacer.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-centerer.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-progress.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-accordion.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/shortcodes/shortcode-section.php';

		/**
		 * Socials
		 */
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/socials/socials.php';
		require_once trailingslashit( FORQY_HOME_DIR ) . 'modules/forqy/socials/share.php';

	}

	add_action( 'plugins_loaded', 'forqy', 20 );

}

if ( ! function_exists( 'forqy_action_links' ) ) {

	/**
	 * Action Links
	 *
	 * @param $links
	 *
	 * @return mixed
	 */
	function forqy_action_links( $links ): array {

		// Settings Link // TODO Add Support Link
		$links['settings'] = '<a href="' . get_admin_url( get_current_blog_id(), 'options-general.php?page=forqy' ) . '">' . __( 'Settings', 'forqy' ) . '</a>';

		return $links;

	}

	add_filter( 'plugin_action_links_forqy/forqy.php', 'forqy_action_links', 10, 1 );

}
